/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.perk;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.common.attribute.AttributeModifier;
import dev.toma.gunsrpg.common.attribute.AttributeOps;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.perk.PerkType;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class CrystalAttribute {
    private final Perk perk;
    private final PerkType type;
    private final int level;
    private final IAttributeModifier modifier;

    public CrystalAttribute(Perk perk, PerkType type, int level) {
        this.perk = perk;
        this.type = type;
        this.level = Math.abs(level);
        this.modifier = this.createUniqueModifier();
    }

    public CrystalAttribute increaseLevel() {
        return new CrystalAttribute(this.perk, this.type, this.level < 0 ? this.level - 1 : this.level + 1);
    }

    public IAttributeModifier createUniqueModifier() {
        long mostSigBits = this.perk.hashCode();
        long leastSigBits = Boolean.hashCode(this.perk.shouldInvertCalculation());
        UUID uniqueId = new UUID(mostSigBits, leastSigBits);
        IModifierOp operation = AttributeOps.MUL;
        double modifier = this.perk.getModifier(this.level, this.type);
        if (this.perk.shouldInvertCalculation()) {
            modifier = -modifier;
        }
        return new AttributeModifier(uniqueId, operation, 1.0 + modifier);
    }

    public static CrystalAttribute flatten(Perk perk, List<CrystalAttribute> list) {
        int totalLevel = 0;
        for (CrystalAttribute attribute : list) {
            int attributeLevel = attribute.getLevel();
            PerkType type = attribute.getType();
            int level = type.getLevel(attributeLevel);
            totalLevel += level;
        }
        PerkType type = totalLevel < 0 ? PerkType.DEBUFF : PerkType.BUFF;
        return new CrystalAttribute(perk, type, totalLevel);
    }

    public IAttributeModifier getModifier() {
        return this.modifier;
    }

    public Perk getPerk() {
        return this.perk;
    }

    public PerkType getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public float getValue() {
        float range = this.perk.getBounds(this.type);
        float value = this.perk.getScaling() * (float)this.level;
        return value < 0.0f ? Math.max(value, -range) : Math.min(value, range);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrystalAttribute attribute = (CrystalAttribute)o;
        return this.getPerk().equals(attribute.getPerk());
    }

    public int hashCode() {
        return this.getPerk().hashCode();
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("perk", this.perk.getPerkId().toString());
        nbt.func_74768_a("level", this.level);
        nbt.func_74768_a("type", this.type.ordinal());
        return nbt;
    }

    public static CrystalAttribute fromNbt(CompoundNBT nbt) {
        ResourceLocation perkId = new ResourceLocation(nbt.func_74779_i("perk"));
        Perk perk = PerkRegistry.getRegistry().getPerkById(perkId);
        if (perk == null) {
            GunsRPG.log.error("Unknown perk {}", (Object)perkId);
            return null;
        }
        int level = nbt.func_74762_e("level");
        PerkType type = PerkType.values()[nbt.func_74762_e("type")];
        return new CrystalAttribute(perk, type, level);
    }
}

